<?php
class Mission { const STATUS_NOT_STARTED = 0; const STATUS_IN_PROGRESS = 1; const STATUS_COMPLETED = 2; const STATUS_FAILED = 3; const TYPE_DATA_THEFT = 'data_theft'; const TYPE_MULTI_STAGE = 'multi_stage'; const TYPE_INFILTRATION = 'infiltration'; const TYPE_SABOTAGE = 'sabotage'; const TYPE_ESPIONAGE = 'espionage'; const TYPE_BACKDOOR = 'backdoor'; const TYPE_CHAIN_HACK = 'chain_hack'; const TYPE_EMAIL_HARVEST = 'email_harvest'; const TYPE_CREDENTIAL_THEFT = 'credential_theft'; const TYPE_LOG_CORRUPTION = 'log_corruption'; const TYPE_FILE_REPLACEMENT = 'file_replacement'; const TYPE_STEALTH_MISSION = 'stealth_mission'; private $id; private $title; private $description; private $difficulty; private $targetIp; private $secondaryIp; private $rewardCredits; private $status; private $completionObjective; private $missionType; private $traceThreshold; private $traceTimer; private $isAvailable; private $yearAvailable; private $monthAvailable; private $completedAt; private $isTutorial; private $active; private $createdAt; private $updatedAt; public function __construct($data) { $this->id = $data['id'] ?? null; $this->title = $data['title']; $this->description = $data['description']; $this->difficulty = $data['difficulty'] ?? 1; $this->targetIp = $data['target_ip']; $this->secondaryIp = $data['secondary_ip'] ?? null; $this->rewardCredits = $data['reward_credits']; $this->status = $data['status'] ?? self::STATUS_NOT_STARTED; $this->completionObjective = $data['completion_objective']; $this->missionType = $data['mission_type']; $this->traceThreshold = $data['trace_threshold'] ?? 70; $this->traceTimer = $data['trace_timer'] ?? 300; $this->isAvailable = $data['is_available'] ?? 0; $this->yearAvailable = $data['year_available'] ?? null; $this->monthAvailable = $data['month_available'] ?? null; $this->completedAt = $data['completed_at'] ?? null; $this->isTutorial = $data['is_tutorial'] ?? 0; $this->active = $data['active'] ?? 0; $this->createdAt = $data['created_at'] ?? null; $this->updatedAt = $data['updated_at'] ?? null; } public function getId() { return $this->id; } public function getTitle() { return $this->title; } public function getDescription() { return $this->description; } public function getDifficulty() { return $this->difficulty; } public function getTargetIp() { return $this->targetIp; } public function getSecondaryIp() { return $this->secondaryIp; } public function getRewardCredits() { return $this->rewardCredits; } public function getStatus() { return $this->status; } public function getCompletionObjective() { return $this->completionObjective; } public function getMissionType() { return $this->missionType; } public function getTraceThreshold() { return $this->traceThreshold; } public function getTraceTimer() { return $this->traceTimer; } public function getIsAvailable() { return $this->isAvailable; } public function getYearAvailable() { return $this->yearAvailable; } public function getMonthAvailable() { return $this->monthAvailable; } public function getCompletedAt() { return $this->completedAt; } public function getIsTutorial() { return $this->isTutorial; } public function getActive() { return $this->active; } public function getCreatedAt() { return $this->createdAt; } public function getUpdatedAt() { return $this->updatedAt; } public function setStatus($status) { $this->status = $status; } public function setCompletedAt($completedAt) { $this->completedAt = $completedAt; } public function setActive($active) { $this->active = $active ? 1 : 0; } public function toArray() { return [ 'id' => $this->id, 'title' => $this->title, 'description' => $this->description, 'difficulty' => $this->difficulty, 'target_ip' => $this->targetIp, 'secondary_ip' => $this->secondaryIp, 'reward_credits' => $this->rewardCredits, 'status' => $this->status, 'completion_objective' => $this->completionObjective, 'mission_type' => $this->missionType, 'trace_threshold' => $this->traceThreshold, 'trace_timer' => $this->traceTimer, 'is_available' => $this->isAvailable, 'year_available' => $this->yearAvailable, 'month_available' => $this->monthAvailable, 'completed_at' => $this->completedAt, 'is_tutorial' => $this->isTutorial, 'active' => $this->active, 'created_at' => $this->createdAt, 'updated_at' => $this->updatedAt ]; } public function save($db) { $this->updatedAt = date('Y-m-d H:i:s'); if ($this->id) { $db->query( "UPDATE missions SET
                title = ?,
                description = ?,
                difficulty = ?,
                target_ip = ?,
                secondary_ip = ?,
                reward_credits = ?,
                status = ?,
                completion_objective = ?,
                mission_type = ?,
                trace_threshold = ?,
                trace_timer = ?,
                is_available = ?,
                year_available = ?,
                month_available = ?,
                completed_at = ?,
                is_tutorial = ?,
                active = ?,
                updated_at = ?
                WHERE id = ?", [ $this->title, $this->description, $this->difficulty, $this->targetIp, $this->secondaryIp, $this->rewardCredits, $this->status, $this->completionObjective, $this->missionType, $this->traceThreshold, $this->traceTimer, $this->isAvailable, $this->yearAvailable, $this->monthAvailable, $this->completedAt, $this->isTutorial, $this->active, $this->updatedAt, $this->id ] ); } else { $this->createdAt = date('Y-m-d H:i:s'); $db->query( "INSERT INTO missions (
                    title, description, difficulty, target_ip, secondary_ip,
                    reward_credits, status, completion_objective, mission_type,
                    trace_threshold, trace_timer, is_available, year_available,
                    month_available, completed_at, is_tutorial, active, created_at, updated_at
                ) VALUES (
                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                )", [ $this->title, $this->description, $this->difficulty, $this->targetIp, $this->secondaryIp, $this->rewardCredits, $this->status, $this->completionObjective, $this->missionType, $this->traceThreshold, $this->traceTimer, $this->isAvailable, $this->yearAvailable, $this->monthAvailable, $this->completedAt, $this->isTutorial, $this->active, $this->createdAt, $this->updatedAt ] ); $result = $db->query("SELECT last_insert_rowid() as id")->fetch(PDO::FETCH_ASSOC); $this->id = $result['id']; } return $this->id; } public static function getById($db, $id) { $result = $db->query("SELECT * FROM missions WHERE id = ?", [$id])->fetch(PDO::FETCH_ASSOC); return $result ? new self($result) : null; } public static function getAvailableMissions($db, $currentYear, $currentMonth) { $stmt = $db->query( "SELECT * FROM missions
             WHERE is_available = 1
             AND ((year_available < ?) OR (year_available = ? AND month_available <= ?))
             AND status = ?
             ORDER BY year_available DESC, month_available DESC", [$currentYear, $currentYear, $currentMonth, self::STATUS_NOT_STARTED] ); $missions = []; while ($mission = $stmt->fetch(PDO::FETCH_ASSOC)) { $missions[] = new self($mission); } return $missions; } public static function getMissionsInProgress($db) { $stmt = $db->query( "SELECT * FROM missions WHERE status = ? ORDER BY id ASC", [self::STATUS_IN_PROGRESS] ); $missions = []; while ($mission = $stmt->fetch(PDO::FETCH_ASSOC)) { $missions[] = new self($mission); } return $missions; } public static function getCompletedMissions($db) { $stmt = $db->query( "SELECT * FROM missions WHERE status = ? ORDER BY completed_at DESC", [self::STATUS_COMPLETED] ); $missions = []; while ($mission = $stmt->fetch(PDO::FETCH_ASSOC)) { $missions[] = new self($mission); } return $missions; } } 